
/* ==================== Photos Controller ==================== */

var photosController = new TKPageSliderController({
	id: 'photos',
	previousPageButton : '.left-arrow',
	nextPageButton : '.right-arrow',
	backButton: '.home',
	activatesFocusedPage : true
});

/* ==================== View Management ==================== */

photosController.viewDidLoad = function () {
	// customize the sliding view
	this.slidingViewData = {
		orientation: TKSlidingViewOrientationHorizontal,
		activeElementIndex: 0,
		sideElementsVisible: 2,
		distanceBetweenElements: 1280,  // distance between the center points of elements
		sideOffsetBefore: 0, // any extra gap you want between center and "before" element
		sideOffsetAfter: 0, // any extra gap you want between center and "after" element
		elements: this.createPhotos(),
		incrementalLoading : true,
		loops:true
	};
	// customize the page control
	this.pageControlData = {
		numPages: appData.numberOfPhotos,
		distanceBetweenPageIndicators: 50,
		showPageElements: false,
		indicatorElement: { type: "emptyDiv" },
		pageElement: { type: "emptyDiv" },
		incrementalJumpsOnly: false,
		allowsDragging: true
	};
};

var hasZoomed = false;

photosController.createPhotos = function () {
	var elements = [];
	for (var i = 1; i <= appData.numberOfPhotos; i++) {
		var padded_index = (i < 9) ? '0' + i : i;
		var url = 'images/photos/photo' + padded_index + '.jpg';
		elements.push({ 
			type: 'container',
			children: [{
				type: 'container',
				className: "image_container image"+i,
				children: [{
					type: 'image', src: url 
				}]
			}]
		});
	}
	return elements;
}

photosController.viewWillAppear = function() {
	if (hasZoomed) {
		this.setHighlightedPageIndex(slideshowController.highlightedPageIndex);
	}
	else {
		this.setHighlightedPageIndex(0);
	}
}

photosController.viewDidAppear = function() {
	
}
		
photosController.pageWasSelected = function (index) {
	// show slideshow controller on activation
	this.photoIndex = index;
	TKNavigationController.sharedNavigation.pushController(slideshowController);
}									

photosController.viewWillDisappear = function() {
	hasZoomed = false;
}

/* ==================== Animation Management - DidAppear ==================== */

photosController.viewDidAppear = function(){	
	setTimeout(photosController.showTitle, 0);
}

photosController.showTitle = function(){
	var titleImage = document.getElementById("title");
	titleImage.style.webkitTransform = "translateY(0)";
	titleImage.style.opacity = 1;
}

photosController.pageWasSelected = function (index) {
	// show slideshow controller on activation
	this.photoIndex = index;
	TKNavigationController.sharedNavigation.pushController(slideshowController);
};										

/* ==================== Animation Management - WillDisappear ==================== */

photosController.viewWillDisappear = function () {
	hasZoomed = false;
	setTimeout(photosController.hideTitle, 0);
}

photosController.hideTitle = function(){
	var titleImage = document.getElementById("title");
	titleImage.style.webkitTransform = "translateY(10px)";
	titleImage.style.opacity = 0;
}